﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Query;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderIdentifiersMap
    {
        public static async Task<IQueryable<ProviderIdentifier>> MapProviderIdentifiers(List<ppms_provideridentifier> ppmsProviderIds, string mapRelatedType, PpmsContext context)
        {
            var providerIds = new List<ProviderIdentifier> { };
            foreach (var ppmsProviderId in ppmsProviderIds)
            {

                //Populate the Npi Detaisl
                var providerId = new ProviderIdentifier
                {
                    Identifier = ppmsProviderId.ppms_ProviderIdentifier,
                };

                if (ppmsProviderId.ppms_Provider != null)
                    providerId.ProviderName = ppmsProviderId.ppms_Provider.Name;

                //Check Provider Identifier Type Field
                OptionSetValue providerIdentifierType = null;
                if (ppmsProviderId.Contains("ppms_identifiertype"))
                {
                    providerIdentifierType = (OptionSetValue)ppmsProviderId.Attributes["ppms_identifiertype"];
                }

                if (providerIdentifierType != null)
                    switch (providerIdentifierType.Value)
                    {
                        case (int)ppms_provideridentifier_ppms_IdentifierType.NPI:
                            providerId.ProviderIdentifierType = ProviderIdentifierType.Npi;

                            if (ppmsProviderId.ppms_SoleProprietor != null)
                                switch (ppmsProviderId.ppms_SoleProprietor.Value)
                                {
                                    case true:
                                        providerId.SoleProprietor = true;
                                        break;
                                    case false:
                                        providerId.SoleProprietor = false;
                                        break;
                                }

                            break;
                        
                        case (int)ppms_provideridentifier_ppms_IdentifierType.TaxIDNumber:
                            providerId.ProviderIdentifierType = ProviderIdentifierType.TaxIdentificationNumber;

                            providerId.OrganizationSubpart = ppmsProviderId.ppms_OrganizationalSubpart;
                            providerId.SubpartLegalBusinessName = ppmsProviderId.ppms_SubpartLegalBusinessName;
                            providerId.SubpartTaxId = ppmsProviderId.ppms_SubpartTaxID;

                            break;
                            
                    }

                providerId.DeactivationReasonCode = ppmsProviderId.ppms_DeactivationReasonCode;
                if (ppmsProviderId.ppms_ReplacementNPI != null)
                    providerId.ReplacementNpiName = ppmsProviderId.ppms_ReplacementNPI.Name;
                if (ppmsProviderId.ppms_EnumerationDate != null)
                    providerId.EnumerationDate = ppmsProviderId.ppms_EnumerationDate.ToString();
                if (ppmsProviderId.ppms_DeactivationDate != null)
                    providerId.DeactivationDate = ppmsProviderId.ppms_DeactivationDate.ToString();
                if (ppmsProviderId.ppms_ReactivationDate != null)
                    providerId.ReactivationDate = ppmsProviderId.ppms_ReactivationDate.ToString();

                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";
                if (mapRelatedType.Contains("?$expand=ReplacementNpi"))
                    mapRelatedType = "ReplacementNpi";
                if (mapRelatedType.Contains("?$expand=Providers"))
                    mapRelatedType = "Providers";
                if (mapRelatedType.Contains("?$expand=ProviderIdentifiers"))
                    mapRelatedType = "ProviderIdentifiers";

                //Map Related Types switch
                switch (mapRelatedType)
                {
                    case "Provider":
                        //Lookup and Map the Single Provider
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderId.ppms_Provider.Id);
                        var ppmsProviderList = new List<Account> { ppmsProvider };
                        providerId.Provider =
                            await ProviderMap.MapProviders(ppmsProviderList, "None", context);
                        break;
                    case "ReplacementNpi":
                        //Lookup and Map the Single Replacement NPI
                        var ppmsReplacementNpi =
                            context.ppms_provideridentifierSet.FirstOrDefault(i => i.Id == ppmsProviderId.ppms_ReplacementNPI.Id);
                        var ppmsReplacementNpiList = new List<ppms_provideridentifier> { ppmsReplacementNpi };
                        providerId.ReplacementNpi =
                            await MapProviderIdentifiers(ppmsReplacementNpiList, "None", context);
                        break;

                    case "Providers":
                        //Lookup and Map the related Providers
                        var ppmsProviders =
                            context.AccountSet.Where(i => i.ppms_ProviderIdentifier == ppmsProviderId.ppms_ProviderIdentifier);
                        var ppmsProvidersList = ppmsProviders.ToList();
                        providerId.Providers =
                            await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                        break;

                    case "ProviderIdentifiers":
                        //Lookup and Map the related Npis
                        var ppmsRelatedproviderIds =
                            context.ppms_provideridentifierSet.Where(i => i.ppms_ReplacementNPI.Id == ppmsProviderId.Id);
                        var ppmsRelatedproviderIdsList = ppmsRelatedproviderIds.ToList();
                        providerId.ProviderIdentifiers =
                            await MapProviderIdentifiers(ppmsRelatedproviderIdsList, "None", context);
                        break;

                    default:
                        break;
                }

                providerIds.Add(providerId);
            }
            return providerIds.AsQueryable();
        }
    }
}